VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "VSDataSource"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Implements IVSReportRecordset

Private Const C_ERRORRAISE As Long = 2500
Private Const SEP = ""
Private Const C_SEP As String = "@@"
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""
Private Const SCREEN_NAME As String = "VSDataSource"
Private Const C_PICTURE_HOLDER As String = "IMG_Id"

Private Enum ArmErr
    DBCnxFailed = vbObjectError + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = vbObjectError + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = vbObjectError + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = vbObjectError + 4
    PropertyNotSet = vbObjectError + 5
    SQLFailure = vbObjectError + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = vbObjectError + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = vbObjectError + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = vbObjectError + 9
    CompFncFailed = vbObjectError + 10           ' when component function fail
    GridLoadFailed = vbObjectError + 11          ' load function failed ... bad sql
    QuietException = vbObjectError + 12          ' do not display error message
    SQLTableReferenceConstraint = vbObjectError + 13 ' A SQL request cannot be executed : Table reference constraint
    InvalidValue = C_ERRORRAISE + 14              ' load function failed ... bad sql
    DuplicityDetected = vbObjectError + 2301     ' detected row with same unique id
End Enum

Private mb_Initialized  As Boolean
Private ml_Cursor As Long
Private ms_Request As String
Private ms_DPCImageCachePath As String

Private Type ParamInfo
    Name As String
    Value As Variant
    Type As ArmSysType
End Type

Private mo_ReportParams() As ParamInfo

#If ENV = LIVE Then
Private mo_Db As Object
Private mo_FSO As Object
#Else
Private mo_Db As ARMSYSCOMLib.ArmDb
Private mo_FSO As FileSystemObject
#End If

Private mo_Tools As DPC_Tools

Public Property Set Tools(ByRef ao_Tools As Object)
On Error GoTo ErrorHandler

  Set mo_Tools = ao_Tools
  Exit Property
ErrorHandler:
  Call ErrorHandler("Tools.Set")
End Property

Public Property Set ArmDb(ByRef lo_Db As Object)
On Error GoTo ErrHandler
  
  Set mo_Db = lo_Db
  Exit Property
ErrHandler:
  Call ErrorHandler("ArmDb.Set")
End Property

Public Property Get Name() As String
  Name = "VSDataSource"
End Property

Public Property Let DataSourceCursor(ByVal ll_Cursor As Long)
On Error GoTo ErrHandler
  
  ml_Cursor = ll_Cursor
  Exit Property
ErrHandler:
  Call ErrorHandler("DataSourceCursor.Let")
End Property

Public Property Let DataSourceRequest(ByVal ls_Request As String)
On Error GoTo ErrHandler
  
  ms_Request = ls_Request
  Exit Property
ErrHandler:
  Call ErrorHandler("DataSourceRequest.Let")
End Property

#If LIVE = 1 Then
Public Sub Load_A_COM()
#Else
Public Sub Load_A_COM()
#End If
On Error GoTo ErrHandler

  If mb_Initialized Then
      Call Err.Raise(ArmErr.CPTAlreadyInitialized)
  End If
  If mo_Db Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet)
  End If
  If mo_Tools Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet)
  End If
  
  ReDim mo_ReportParams(-1 To -1)
    
  Set mo_FSO = New FileSystemObject
  
  ms_DPCImageCachePath = prg.AppCache_Dir & DPC_IMAGE_CACHE
  
  mb_Initialized = True
  Exit Sub
ErrHandler:
  Call ErrorHandler("Load_A_COM")
End Sub

#If LIVE = 1 Then
Public Sub Unload_A_COM()
#Else
Public Sub Unload_A_COM()
#End If
On Error GoTo ErrHandler
            
  If ml_Cursor > 0 Then
    mo_Db.Close (ml_Cursor)
  End If
  
  Set mo_Db = Nothing
  Set mo_FSO = Nothing
  
  ReDim mo_ReportParams(-1 To -1)
  
  mb_Initialized = False
  Exit Sub
ErrHandler:
  Call ErrorHandler("Unload_A_COM")
End Sub

' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
  
    Call Err.Raise(Err.Number, "VSDataSource." & as_Fct & SEP1 & Err.Source, Err.Description)
End Sub

Public Function OpenDataSourceCursor() As Long
On Error GoTo ErrHandler
            
  Dim ls_Request As String
  Dim lo_ParamInfo As ParamInfo
  Dim ll_Index As Long
  
  ls_Request = ms_Request
  
  For ll_Index = 0 To UBound(mo_ReportParams)
  
    lo_ParamInfo = mo_ReportParams(ll_Index)
        
    Select Case lo_ParamInfo.Type
    Case ArmSysType.DBTYPE_STR, ArmSysType.DBTYPE_BSTR
        ls_Request = Replace(ls_Request, "$" & lo_ParamInfo.Name & "$", mo_Tools.SQLStr(lo_ParamInfo.Value), , , vbTextCompare)
    Case ArmSysType.DBTYPE_I4
        ls_Request = Replace(ls_Request, "$" & lo_ParamInfo.Name & "$", mo_Tools.SqlInt(lo_ParamInfo.Value), , , vbTextCompare)
    Case ArmSysType.DBTYPE_R4, ArmSysType.DBTYPE_R8
        ls_Request = Replace(ls_Request, "$" & lo_ParamInfo.Name & "$", mo_Tools.SqlDbl(lo_ParamInfo.Value), , , vbTextCompare)
    Case ArmSysType.DBTYPE_DATE
        ls_Request = Replace(ls_Request, "$" & lo_ParamInfo.Name & "$", mo_Tools.SqlDate(lo_ParamInfo.Value), , , vbTextCompare)
    Case ArmSysType.DBTYPE_BOOL
        ls_Request = Replace(ls_Request, "$" & lo_ParamInfo.Name & "$", mo_Tools.SqlBool(lo_ParamInfo.Value), , , vbTextCompare)
    End Select
    
  Next
  
  OpenDataSourceCursor = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
    
  Exit Function
ErrHandler:
  Call ErrorHandler("OpenDataSourceCursor")
End Function

Public Sub AddParam(ByVal as_ParamName As String, ByVal av_ParamValue As Variant, ByVal al_ParamType As ArmSysType)
On Error GoTo ErrHandler
            
    If UBound(mo_ReportParams) = -1 Then
        ReDim mo_ReportParams(0)
    Else
        ReDim Preserve mo_ReportParams(UBound(mo_ReportParams) + 1)
    End If

    mo_ReportParams(UBound(mo_ReportParams)).Name = as_ParamName
    mo_ReportParams(UBound(mo_ReportParams)).Value = av_ParamValue
    mo_ReportParams(UBound(mo_ReportParams)).Type = al_ParamType
  
  Exit Sub
ErrHandler:
  Call ErrorHandler("AddParam")
End Sub

Public Function LoadData() As Boolean
On Error GoTo ErrHandler
            
  LoadData = False
  
  If ml_Cursor = 0 Then
    ml_Cursor = OpenDataSourceCursor()
    
    If ml_Cursor = 0 Then
        Call Err.Raise(ArmErr.PropertyNotSet)
    End If
  End If
    
  LoadData = True
  
  Exit Function
ErrHandler:
  Call ErrorHandler("LoadData")
End Function

Private Sub IVSReportRecordset_ApplyFilter(ByVal Filter As String)
On Error GoTo ErrHandler
    Debug.Print "Ignoring filter: "; Filter
  Exit Sub
ErrHandler:
  Call ErrorHandler("IVSReportRecordset_ApplyFilter")
End Sub

Private Sub IVSReportRecordset_ApplySort(ByVal Sort As String)
On Error GoTo ErrHandler
    Debug.Print "Ignoring sort: "; Sort
  Exit Sub
ErrHandler:
  Call ErrorHandler("IVSReportRecordset_ApplySort")
End Sub

Private Function IVSReportRecordset_GetBookmark() As Variant
On Error GoTo ErrHandler
    IVSReportRecordset_GetBookmark = mo_Db.Position(ml_Cursor)
  Exit Function
ErrHandler:
  Call ErrorHandler("IVSReportRecordset_GetBookmark")
End Function

Private Sub IVSReportRecordset_SetBookmark(newVal As Variant)
On Error GoTo ErrHandler
    If newVal < 0 Or newVal > mo_Db.RowCount(ml_Cursor) Then
        Err.Raise ArmErr.InvalidArgument, , "Invalid Bookmark in IVSReportRecordset_SetBookmark"
    Else
        mo_Db.Position(ml_Cursor) = newVal
    End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("IVSReportRecordset_SetBookmark")
End Sub

Private Function IVSReportRecordset_GetFieldCount() As Long
On Error GoTo ErrHandler
    IVSReportRecordset_GetFieldCount = mo_Db.FieldCount(ml_Cursor)
  Exit Function
ErrHandler:
  Call ErrorHandler("IVSReportRecordset_GetFieldCount")
End Function

Private Function IVSReportRecordset_GetFieldName(ByVal Index As Long) As String
On Error GoTo ErrHandler

    IVSReportRecordset_GetFieldName = mo_Db.GetFieldName(ml_Cursor, Index)
  Exit Function
ErrHandler:
  Call ErrorHandler("IVSReportRecordset_GetFieldName")
End Function

Private Function IVSReportRecordset_GetFieldSize(ByVal Index As Long) As Long
On Error GoTo ErrHandler

  If StrComp(C_PICTURE_HOLDER, mo_Db.GetFieldName(ml_Cursor, Index), vbTextCompare) = 0 Then
      'ls_req = "Select IMG_File from DPC_Image WHERE IMG_Id=" & mo_Db.GetFields(ml_Cursor, mo_Db.Fields(ml_Cursor)(Index))
      'll_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
      'IVSReportRecordset_GetFieldSize = mo_Db.GetFieldSize(ll_Cursor, "IMG_File")
      'Call mo_Db.Close(ll_Cursor)
      'IVSReportRecordset_GetFieldValue = mo_Tools.LoadDPCImage(mo_Db, mo_FSO, ms_DPCImageCachePath, mo_Db.GetFields(ml_Cursor, mo_Db.Fields(ml_Cursor)(Index)))
      IVSReportRecordset_GetFieldSize = 1000 '2147483647
  Else
    IVSReportRecordset_GetFieldSize = mo_Db.GetFieldSize(ml_Cursor, Index)
  End If
  Exit Function
ErrHandler:
  Call ErrorHandler("IVSReportRecordset_GetFieldSize")
End Function

Private Function IVSReportRecordset_GetFieldType(ByVal Index As Long) As Long
On Error GoTo ErrHandler
    
  If StrComp(C_PICTURE_HOLDER, mo_Db.GetFieldName(ml_Cursor, Index), vbTextCompare) = 0 Then
    IVSReportRecordset_GetFieldType = 8 '205 ' 128 '+ 16384  ' binary
  ElseIf mo_Db.GetFieldType(ml_Cursor, Index) = DBTYPE_DATE Then
    IVSReportRecordset_GetFieldType = 7 ' date
  ElseIf mo_Db.GetFieldType(ml_Cursor, Index) = DBTYPE_I4 Then
    IVSReportRecordset_GetFieldType = 3 ' int
  ElseIf mo_Db.GetFieldType(ml_Cursor, Index) = DBTYPE_R4 Then
    IVSReportRecordset_GetFieldType = 5 ' double
  Else
    IVSReportRecordset_GetFieldType = 8 ' string
  End If
  Exit Function
ErrHandler:
  Call ErrorHandler("IVSReportRecordset_GetFieldType")
End Function

'Private Function ReadFile2(sFile As String) As Byte()
'    Dim nFile       As Integer
'    Dim ab_Bytes() As Byte
'    Dim lFileLength As Long
'
'    nFile = FreeFile
'    Open sFile For Binary Access Read As #nFile
'    lFileLength = LOF(nFile)
'    If lFileLength > 0 Then
'        ReDim ab_Bytes(lFileLength)
'        Get nFile, , ab_Bytes()
'    End If
'    Close #nFile
'    ReadFile2 = ab_Bytes
'End Function
'
Private Function IVSReportRecordset_GetFieldValue(ByVal Index As Long) As Variant
On Error GoTo ErrHandler
    
Dim ll_Cursor As Long
Dim ls_req As String
'Dim st As Object
'Dim rs As ADODB.Recordset
'Dim cn As ADODB.Connection
Dim lv_Value As Variant

  If StrComp(C_PICTURE_HOLDER, mo_Db.GetFieldName(ml_Cursor, Index), vbTextCompare) = 0 Then
      
      'IVSReportRecordset_GetFieldValue = ReadFile2(ms_DPCImageCachePath & "IMG" & mo_Db.GetFields(ml_Cursor, "IMG_Id") & ".jpg")   'mo_Tools.LoadDPCImage(mo_Db, mo_FSO, ms_DPCImageCachePath, mo_Db.GetFields(ml_Cursor, "IMG_Id"))
      
      'Initialize the stream object used to load the file.
'        Set cn = New ADODB.Connection
'        cn.ConnectionString = "Provider=SQLNCLI10.1;Integrated Security="""";Persist Security Info=False;User ID=sa;Initial Catalog=small_sifyb;Data Source=localhost;Initial File Name="""";Server SPN="""""
'        cn.Open
'        Set rs = cn.Execute("SELECT * FROM DPC_Image where img_id=12345")
'        lv_Value = rs.Fields(1).Value
      
'        Set st = CreateObject("ADODB.Stream") 'New ADODB.Stream
'        st.Type = 1 'adTypeBinary
'        st.Open
'        Call st.LoadFromFile(ms_DPCImageCachePath & "IMG" & mo_Db.GetFields(ml_Cursor, "IMG_Id") & ".jpg")
      'Set IVSReportRecordset_GetFieldValue = st
      
      'Set VSReportRecordset_GetFieldValue = mo_Tools.LoadDPCImage(mo_Db, mo_FSO, ms_DPCImageCachePath, mo_Db.GetFields(ml_Cursor, "IMG_Id"))
      'lv_Value = ReadFile2(ms_DPCImageCachePath & "IMG" & mo_Db.GetFields(ml_Cursor, "IMG_Id") & ".jpg")
      'IVSReportRecordset_GetFieldValue = lv_Value
      ' this needs to be here to ensure image will be loaded into cache directory, so report can display it from there
      Call mo_Tools.LoadDPCImage(mo_Db, mo_FSO, ms_DPCImageCachePath, mo_Db.GetFields(ml_Cursor, "IMG_Id"))
      IVSReportRecordset_GetFieldValue = ms_DPCImageCachePath & "IMG" & mo_Db.GetFields(ml_Cursor, "IMG_Id") & ".jpg"
  Else
    IVSReportRecordset_GetFieldValue = mo_Db.GetFields(ml_Cursor, Index)
  End If
  Exit Function
ErrHandler:
  Call ErrorHandler("IVSReportRecordset_GetFieldValue")
End Function

Private Sub IVSReportRecordset_MoveFirst()
On Error GoTo ErrHandler
    Call mo_Db.First(ml_Cursor)
  Exit Sub
ErrHandler:
  Call ErrorHandler("IVSReportRecordset_MoveFirst")
End Sub

Private Sub IVSReportRecordset_MoveLast()
On Error GoTo ErrHandler
    Call mo_Db.Last(ml_Cursor)
  Exit Sub
ErrHandler:
  Call ErrorHandler("IVSReportRecordset_MoveLast")
End Sub

Private Sub IVSReportRecordset_MoveNext()
On Error GoTo ErrHandler
    'If Not mo_Db.Bof(ml_Cursor) Then
        Call mo_Db.Next(ml_Cursor)
    'End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("IVSReportRecordset_MoveNext")
End Sub

Private Sub IVSReportRecordset_MovePrevious()
On Error GoTo ErrHandler
    If Not mo_Db.EOF(ml_Cursor) Then
        Call mo_Db.Previous(ml_Cursor)
    End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("IVSReportRecordset_MovePrevious")
End Sub

Private Function IVSReportRecordset_BegOfFile() As Boolean
On Error GoTo ErrHandler
    IVSReportRecordset_BegOfFile = IIf(mo_Db.Bof(ml_Cursor) = 0, False, True)
  Exit Function
ErrHandler:
  Call ErrorHandler("IVSReportRecordset_BegOfFile")
End Function

Private Function IVSReportRecordset_EndOfFile() As Boolean
On Error GoTo ErrHandler
    IVSReportRecordset_EndOfFile = IIf(mo_Db.EOF(ml_Cursor) = 0, False, True)
  Exit Function
ErrHandler:
  Call ErrorHandler("IVSReportRecordset_EndOfFile")
End Function

